<?php
// হেডারকে JSON হিসেবে সেট করুন
header('Content-Type: application/json');
// ডেটাবেস সংযোগ
include '../includes/db.php';

$response = array();
$categories = array();

$sql = "SELECT id, name FROM categories ORDER BY name ASC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $category_item = array(
            'id' => $row['id'],
            'name' => $row['name']
        );
        array_push($categories, $category_item);
    }
    $response['status'] = 'success';
    $response['categories'] = $categories;
} else {
    $response['status'] = 'error';
    $response['message'] = 'No categories found';
}

echo json_encode($response);

$conn->close();
?>